/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class I18n {
    private static ResourceBundle i18n;
    static String PROMPT_YES;
    static String PROMPT_NO;
    static String PROMPT_CANCEL;
    static String PROMPT_OK;
    static String PROMPT_BROWSE;

    protected static void init(String language) {
        try {
            if (language != null && language.trim().length() > 0) {
                Locale.setDefault(new Locale(language));
            }
            i18n = ResourceBundle.getBundle("processing.app.Resources", Locale.getDefault());
            PROMPT_YES = I18n._("Yes");
            PROMPT_NO = I18n._("No");
            PROMPT_CANCEL = I18n._("Cancel");
            PROMPT_OK = I18n._("OK");
            PROMPT_BROWSE = I18n._("Browse");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public static String _(String s) {
        try {
            return i18n.getString(s);
        }
        catch (MissingResourceException e) {
            return s;
        }
    }

    public static String format(String fmt, Object ... args) {
        return MessageFormat.format(fmt, args);
    }
}

