/*
 * Decompiled with CFR 0.152.
 */
package processing.app;

import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import processing.app.Editor;
import processing.app.Preferences;
import processing.app.Sketch;
import processing.app.syntax.JEditTextArea;

public class EditorListener {
    private Editor editor;
    private JEditTextArea textarea;
    private boolean externalEditor;
    private boolean tabsExpand;
    private boolean tabsIndent;
    private int tabSize;
    private String tabString;
    private boolean autoIndent;
    static final int CTRL_ALT = 8 | Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();

    public EditorListener(Editor editor, JEditTextArea textarea) {
        this.editor = editor;
        this.textarea = textarea;
        textarea.editorListener = this;
        this.applyPreferences();
    }

    public void applyPreferences() {
        this.tabsExpand = Preferences.getBoolean("editor.tabs.expand");
        this.tabSize = Preferences.getInteger("editor.tabs.size");
        this.tabString = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
        this.autoIndent = Preferences.getBoolean("editor.indent");
        this.externalEditor = Preferences.getBoolean("editor.external");
    }

    public boolean keyPressed(KeyEvent event) {
        if (this.externalEditor) {
            return false;
        }
        char c = event.getKeyChar();
        int code = event.getKeyCode();
        Sketch sketch = this.editor.getSketch();
        if ((event.getModifiers() & CTRL_ALT) == CTRL_ALT) {
            if (code == 37) {
                sketch.handlePrevCode();
                return true;
            }
            if (code == 39) {
                sketch.handleNextCode();
                return true;
            }
        }
        if ((event.getModifiers() & 2) != 0 && code == 77) {
            event.consume();
            return false;
        }
        if ((event.getModifiers() & 4) != 0) {
            return false;
        }
        if (!this.editor.getSketch().isModified() && (code == 8 || code == 9 || code == 10 || c >= ' ' && c < '\u0080')) {
            sketch.setModified(true);
        }
        if (code == 38 && (event.getModifiers() & 2) != 0) {
            char[] contents = this.textarea.getText().toCharArray();
            int caretIndex = this.textarea.getCaretPosition();
            int index = this.calcLineStart(caretIndex - 1, contents);
            index -= 2;
            boolean onlySpaces = true;
            while (index > 0) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        ++index;
                        break;
                    }
                    onlySpaces = true;
                } else if (contents[index] != ' ') {
                    onlySpaces = false;
                }
                --index;
            }
            if (index < 0) {
                index = 0;
            }
            if ((event.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(caretIndex);
                this.textarea.setSelectionEnd(index);
            } else {
                this.textarea.setCaretPosition(index);
            }
            event.consume();
            return true;
        }
        if (code == 40 && (event.getModifiers() & 2) != 0) {
            int caretIndex;
            int index;
            char[] contents = this.textarea.getText().toCharArray();
            int lineStart = 0;
            boolean onlySpaces = false;
            for (index = caretIndex = this.textarea.getCaretPosition(); index < contents.length; ++index) {
                if (contents[index] == '\n') {
                    if (onlySpaces) {
                        index = lineStart;
                        break;
                    }
                    lineStart = index + 1;
                    onlySpaces = true;
                    continue;
                }
                if (contents[index] == ' ') continue;
                onlySpaces = false;
            }
            if ((event.getModifiers() & 1) != 0) {
                this.textarea.setSelectionStart(caretIndex);
                this.textarea.setSelectionEnd(index);
            } else {
                this.textarea.setCaretPosition(index);
            }
            event.consume();
            return true;
        }
        switch (c) {
            case '\t': {
                int lineStart;
                int lineEnd;
                if (this.textarea.isSelectionActive()) {
                    boolean outdent = (event.getModifiers() & 1) != 0;
                    this.editor.handleIndentOutdent(!outdent);
                    break;
                }
                if (this.tabsExpand) {
                    this.textarea.setSelectedText(this.tabString);
                    event.consume();
                    return true;
                }
                if (!this.tabsIndent) break;
                char[] contents = this.textarea.getText().toCharArray();
                int prevCharIndex = this.textarea.getCaretPosition() - 1;
                for (lineEnd = lineStart = this.calcLineStart(prevCharIndex, contents); lineEnd < contents.length - 1 && contents[lineEnd] != '\n'; ++lineEnd) {
                }
                int braceBalance = 0;
                for (int index = lineStart; index < contents.length && contents[index] != '\n'; ++index) {
                    if (contents[index] == '{') {
                        ++braceBalance;
                        continue;
                    }
                    if (contents[index] != '}') continue;
                    --braceBalance;
                }
                int where = braceBalance > 0 ? lineStart : lineEnd;
                int indent = this.calcBraceIndent(where, contents);
                indent = indent == -1 ? 0 : (indent += this.tabSize);
                int spaceCount = this.calcSpaceCount(prevCharIndex, contents);
                this.textarea.setSelectionStart(lineStart);
                this.textarea.setSelectionEnd(lineStart + spaceCount);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, indent));
                event.consume();
                return true;
            }
            case '\n': 
            case '\r': {
                if (this.autoIndent) {
                    int sel;
                    int index;
                    int index2;
                    char[] contents = this.textarea.getText().toCharArray();
                    int origIndex = this.textarea.getCaretPosition() - 1;
                    int spaceCount = this.calcSpaceCount(origIndex, contents);
                    for (index2 = origIndex; index2 >= 0 && Character.isWhitespace(contents[index2]); --index2) {
                    }
                    if (index2 != -1 && contents[index2] == '{') {
                        spaceCount = this.calcSpaceCount(index2, contents);
                        spaceCount += this.tabSize;
                    }
                    int extraCount = 0;
                    for (index = origIndex + 1; index < contents.length && contents[index] == ' '; ++index) {
                        ++extraCount;
                    }
                    int braceCount = 0;
                    while (index < contents.length && contents[index] != '\n') {
                        if (contents[index] == '}') {
                            ++braceCount;
                        }
                        ++index;
                    }
                    if ((spaceCount -= extraCount) < 0) {
                        this.textarea.setSelectionEnd(this.textarea.getSelectionStop() - spaceCount);
                        this.textarea.setSelectedText("\n");
                    } else {
                        String insertion = "\n" + "                                                                                                                                                                                                               ".substring(0, spaceCount);
                        this.textarea.setSelectedText(insertion);
                    }
                    if (braceCount > 0 && (sel = this.textarea.getSelectionStart()) - this.tabSize >= 0) {
                        this.textarea.select(sel - this.tabSize, sel);
                        String s = "                                                                                                                                                                                                               ".substring(0, this.tabSize);
                        if (this.textarea.getSelectedText().equals(s)) {
                            this.textarea.setSelectedText("");
                        } else {
                            this.textarea.select(sel, sel);
                        }
                    }
                } else {
                    this.textarea.setSelectedText(String.valueOf(c));
                }
                event.consume();
                return true;
            }
            case '}': {
                int prevCharIndex;
                if (!this.autoIndent) break;
                if (this.textarea.getSelectionStart() != this.textarea.getSelectionStop()) {
                    this.textarea.setSelectedText("");
                }
                char[] contents = this.textarea.getText().toCharArray();
                int index = prevCharIndex = this.textarea.getCaretPosition() - 1;
                boolean finished = false;
                while (index != -1 && !finished) {
                    if (contents[index] == '\n') {
                        finished = true;
                        ++index;
                        continue;
                    }
                    if (contents[index] != ' ') {
                        return false;
                    }
                    --index;
                }
                if (!finished) {
                    return false;
                }
                int lineStartIndex = index;
                int pairedSpaceCount = this.calcBraceIndent(prevCharIndex, contents);
                if (pairedSpaceCount == -1) {
                    return false;
                }
                this.textarea.setSelectionStart(lineStartIndex);
                this.textarea.setSelectedText("                                                                                                                                                                                                               ".substring(0, pairedSpaceCount));
                event.consume();
                return true;
            }
        }
        return false;
    }

    public boolean keyTyped(KeyEvent event) {
        char c = event.getKeyChar();
        if ((event.getModifiers() & 2) != 0 && c == ',') {
            event.consume();
            return true;
        }
        return false;
    }

    protected int calcLineStart(int index, char[] contents) {
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '\n' || contents[index] == '\r') {
                finished = true;
                continue;
            }
            --index;
        }
        return index + 1;
    }

    protected int calcSpaceCount(int index, char[] contents) {
        index = this.calcLineStart(index, contents);
        int spaceCount = 0;
        while (index < contents.length && index >= 0 && contents[index++] == ' ') {
            ++spaceCount;
        }
        return spaceCount;
    }

    protected int calcBraceIndent(int index, char[] contents) {
        int braceDepth = 1;
        boolean finished = false;
        while (index != -1 && !finished) {
            if (contents[index] == '}') {
                ++braceDepth;
                --index;
                continue;
            }
            if (contents[index] == '{') {
                if (--braceDepth == 0) {
                    finished = true;
                }
                --index;
                continue;
            }
            --index;
        }
        if (!finished) {
            return -1;
        }
        return this.calcSpaceCount(index, contents);
    }

    protected char[] getCleanedContents() {
        char[] c = this.textarea.getText().toCharArray();
        int index = 0;
        while (index < c.length - 1) {
            if (c[index] == '/' && c[index + 1] == '*') {
                c[index++] = '\u0000';
                c[index++] = '\u0000';
                while (index < c.length - 1 && (c[index] != '*' || c[index + 1] != '/')) {
                    c[index++] = '\u0000';
                }
                continue;
            }
            if (c[index] != '/' || c[index + 1] != '/') continue;
            while (index < c.length && c[index] != '\n') {
                c[index++] = '\u0000';
            }
            if (index == c.length) continue;
            ++index;
        }
        return c;
    }
}

