/*
 * Decompiled with CFR 0.152.
 */
package processing.app.debug;

import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import processing.app.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Target {
    private String name;
    private File folder;
    private Map boards;
    private Map programmers;

    public Target(String name, File folder) {
        this.name = name;
        this.folder = folder;
        this.boards = new LinkedHashMap();
        this.programmers = new LinkedHashMap();
        File boardsFile = new File(folder, "boards.txt");
        try {
            if (boardsFile.exists()) {
                LinkedHashMap boardPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(boardsFile), boardPreferences);
                for (Object k : boardPreferences.keySet()) {
                    String key = (String)k;
                    String board = key.substring(0, key.indexOf(46));
                    if (!this.boards.containsKey(board)) {
                        this.boards.put(board, new HashMap());
                    }
                    ((Map)this.boards.get(board)).put(key.substring(key.indexOf(46) + 1), boardPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading boards from " + boardsFile + ": " + e);
        }
        File programmersFile = new File(folder, "programmers.txt");
        try {
            if (programmersFile.exists()) {
                LinkedHashMap programmerPreferences = new LinkedHashMap();
                Preferences.load(new FileInputStream(programmersFile), programmerPreferences);
                for (Object k : programmerPreferences.keySet()) {
                    String key = (String)k;
                    String programmer = key.substring(0, key.indexOf(46));
                    if (!this.programmers.containsKey(programmer)) {
                        this.programmers.put(programmer, new HashMap());
                    }
                    ((Map)this.programmers.get(programmer)).put(key.substring(key.indexOf(46) + 1), programmerPreferences.get(key));
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error loading programmers from " + programmersFile + ": " + e);
        }
    }

    public String getName() {
        return this.name;
    }

    public File getFolder() {
        return this.folder;
    }

    public Map<String, Map<String, String>> getBoards() {
        return this.boards;
    }

    public Map<String, Map<String, String>> getProgrammers() {
        return this.programmers;
    }
}

